/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.shape;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_259;
import net.minecraft.class_265;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.collision.CollisionHelper;
import qouteall.imm_ptl.core.collision.PortalCollisionHandler;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.imm_ptl.core.portal.shape.PortalShape;
import qouteall.imm_ptl.core.portal.shape.PortalShapeSerialization;
import qouteall.imm_ptl.core.render.FrustumCuller;
import qouteall.imm_ptl.core.render.ViewAreaRenderer;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.my_util.BoxPredicateF;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Range;
import qouteall.q_misc_util.my_util.RayTraceResult;
import qouteall.q_misc_util.my_util.TriangleConsumer;

public final class RectangularPortalShape
implements PortalShape {
    public static final RectangularPortalShape INSTANCE = new RectangularPortalShape();

    public static void init() {
        PortalShapeSerialization.addSerializer(new PortalShapeSerialization.Serializer<RectangularPortalShape>("rectangular", RectangularPortalShape.class, s -> new class_2487(), t -> INSTANCE));
    }

    @Override
    public boolean isPlanar() {
        return true;
    }

    @Override
    public class_238 getBoundingBox(UnilateralPortalState portalState, boolean limitSize, double boxExpand) {
        double halfW = portalState.width() / 2.0;
        double halfH = portalState.height() / 2.0;
        if (limitSize) {
            halfW = Math.min(halfW, 64.0);
            halfH = Math.min(halfH, 64.0);
        }
        return Helper.boundingBoxOfPoints(new class_243[]{portalState.transformLocalToGlobal(halfW, halfH, boxExpand), portalState.transformLocalToGlobal(halfW, -halfH, boxExpand), portalState.transformLocalToGlobal(-halfW, halfH, boxExpand), portalState.transformLocalToGlobal(-halfW, -halfH, boxExpand), portalState.transformLocalToGlobal(halfW, halfH, -boxExpand), portalState.transformLocalToGlobal(halfW, -halfH, -boxExpand), portalState.transformLocalToGlobal(-halfW, halfH, -boxExpand), portalState.transformLocalToGlobal(-halfW, -halfH, -boxExpand)});
    }

    @Override
    public double roughDistanceToPortalShape(UnilateralPortalState portalState, class_243 pos) {
        class_243 localPos = portalState.transformGlobalToLocal(pos);
        double distToRec = Helper.getDistanceToRectangle(localPos.method_10216(), localPos.method_10214(), -portalState.width() / 2.0, -portalState.height() / 2.0, portalState.width() / 2.0, portalState.height() / 2.0);
        return Math.sqrt(distToRec * distToRec + localPos.method_10215() * localPos.method_10215());
    }

    @Override
    @Nullable
    public RayTraceResult raytracePortalShapeByLocalPos(UnilateralPortalState portalState, class_243 localFrom, class_243 localTo, double leniency) {
        double width = portalState.width();
        double height = portalState.height();
        if (localFrom.method_10215() > 0.0 && localTo.method_10215() < 0.0) {
            double deltaZ = localTo.method_10215() - localFrom.method_10215();
            double t = -localFrom.method_10215() / deltaZ;
            class_243 hit = localFrom.method_1019(localTo.method_1020(localFrom).method_1021(t));
            if (Math.abs(hit.method_10216()) < width / 2.0 + leniency && Math.abs(hit.method_10214()) < height / 2.0 + leniency) {
                return new RayTraceResult(t, hit, new class_243(0.0, 0.0, 1.0));
            }
        }
        return null;
    }

    @Override
    public Plane getOuterClipping(UnilateralPortalState portalState) {
        return new Plane(portalState.position(), portalState.getNormal());
    }

    @Override
    public Plane getInnerClipping(UnilateralPortalState thisSideState, UnilateralPortalState otherSideState, Portal portal) {
        return new Plane(otherSideState.position(), otherSideState.getNormal());
    }

    @Override
    public PortalShape getFlipped() {
        return this;
    }

    @Override
    public PortalShape getReverse() {
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void renderViewAreaMesh(class_243 portalOriginRelativeToCamera, UnilateralPortalState portalState, TriangleConsumer vertexOutput, boolean isGlobalPortal) {
        double w = Math.min(portalState.width(), 23333.0);
        double h = Math.min(portalState.height(), 23333.0);
        class_243 localXAxis = portalState.getAxisW().method_1021(w / 2.0);
        class_243 localYAxis = portalState.getAxisH().method_1021(h / 2.0);
        ViewAreaRenderer.outputFullQuad(vertexOutput, portalOriginRelativeToCamera, localXAxis, localYAxis);
    }

    @Override
    public boolean roughTestVisibility(UnilateralPortalState portalState, class_243 cameraPos, boolean isIrisShaderOn) {
        class_243 localPos = portalState.transformGlobalToLocal(cameraPos);
        return localPos.method_10215() > 0.0;
    }

    @Override
    public boolean canCollideWith(Portal portal, UnilateralPortalState portalState, class_243 entityEyePos, class_238 entityBoundingBox) {
        boolean inFrontOfPortal;
        boolean bl = inFrontOfPortal = portalState.transformGlobalToLocal(entityEyePos).method_10215() > 0.0;
        if (!inFrontOfPortal) {
            return false;
        }
        return this.isBoxInPortalProjection(portalState, entityBoundingBox);
    }

    @Override
    public boolean isLocalBoxInPortalProjection(UnilateralPortalState portalState, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        double halfWidth = portalState.width() / 2.0;
        double halfHeight = portalState.height() / 2.0;
        return Range.rangeIntersects(-halfWidth, halfWidth, minX, maxX) && Range.rangeIntersects(-halfHeight, halfHeight, minY, maxY);
    }

    @Override
    public class_243 getMovementForPushingEntityOutOfPortal(Portal portal, UnilateralPortalState portalState, class_1297 entity, class_243 attemptedMove) {
        class_238 originalBoundingBox = entity.method_5829();
        return PortalCollisionHandler.getMovementForPushingEntityOutOfPortal(attemptedMove, portalState.position(), portalState.getNormal(), originalBoundingBox);
    }

    @Override
    public PortalShape cloneIfNecessary() {
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean canDoOuterFrustumCulling() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public BoxPredicateF getInnerFrustumCullingFunc(Portal portal, class_243 cameraPos) {
        return FrustumCuller.getFlatPortalInnerFrustumCullingFunc(portal, cameraPos);
    }

    @Override
    public BoxPredicateF getOuterFrustumCullingFunc(Portal portal, class_243 cameraPos) {
        return FrustumCuller.getFlatPortalOuterFrustumCullingFunc(portal, cameraPos);
    }

    @Override
    public boolean shouldRenderInside(Portal portal, class_238 box) {
        Plane innerClipping = this.getInnerClipping(portal.getThisSideState(), portal.getOtherSideState(), portal);
        double testX = innerClipping.normal().field_1352 < 0.0 ? box.field_1323 : box.field_1320;
        double testY = innerClipping.normal().field_1351 < 0.0 ? box.field_1322 : box.field_1325;
        double testZ = innerClipping.normal().field_1350 < 0.0 ? box.field_1321 : box.field_1324;
        return innerClipping.isPointOnPositiveSide(new class_243(testX, testY, testZ));
    }

    @Override
    public class_265 getThisSideCollisionExclusion(UnilateralPortalState portalState) {
        class_238 thinAreaBox = this.getBoundingBox(portalState, true, 0.0);
        class_243 reaching = portalState.getNormal().method_1021(-10.0);
        class_238 exclusion = thinAreaBox.method_991(thinAreaBox.method_997(reaching));
        return class_259.method_1078((class_238)exclusion);
    }

    @Override
    @Nullable
    public class_238 transformEntityActiveCollisionBox(Portal portal, class_238 box, class_1297 entity) {
        return CollisionHelper.clipBox(box, portal.getOriginPos(), portal.getNormal());
    }
}

